import path_setting
from in_common.base_request import BaseRequest
from bs4 import BeautifulSoup


class hybrid_request(BaseRequest):
    def __init__(self):
        #百科详情页-项目聚合百科
        self.data = self.api_load(path_setting.SUBWIKI_CONFIG)
        #百科详情页-项目百科
        self.data = self.api_load(path_setting.BASEWIKI_ITEM_CONFIG)
        #百科详情页-药品（仪器、材料）百科
        self.data = self.api_load(path_setting.BASEWIKI_PRODUCT_CONFIG)
        #百科详情页-品牌百科
        self.data = self.api_load(path_setting.BRAND_CONFIG)


    #百科详情页-项目聚合百科
    def sub_wiki(self, version, current_city_id, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['current_city_id'] = current_city_id
        self.params['version'] = version

        return self.api_send(self.data['sub_wiki'])
        # return self.data

    #百科详情页-项目百科
    def basewiki_item(self, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['version'] = version

        return self.api_send(self.data['basewiki_item'])

    #百科详情页-药品（仪器、材料）百科
    def basewiki_product(self, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['version'] = version

        return self.api_send(self.data['basewiki_product'])

    #百科详情页-品牌百科
    def brand(self, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['version'] = version

        return self.api_send(self.data['brand'])


if __name__ == '__main__':
    # print(self.data)
    # print(hybrid_request().sub_wiki("744.0", "beijing"))
    # print(type(hybrid_request().sub_wiki("744.0", "beijing")))
    soup = BeautifulSoup(hybrid_request().sub_wiki("744.0", "beijing"), 'lxml')  # html.parser是解析器，也可是lxml
    print(soup.prettify(),'百科详情页-项目聚合百科') #输出soup对象的内容
    print(soup.title)