import path_setting
from in_common.base_request import BaseRequest


class search_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.KEYWORDS_CONFIG)
        #品类聚合页面医生tab列表
        self.data = self.api_load(path_setting.HOSPITAL_CONFIG)
        self.data = self.api_load(path_setting.KEYWORDS_CONFIG) #keywords路径
        self.data = self.api_load(path_setting.CONTENTV6_CONFIG) #content_v6路径
        self.data = self.api_load(path_setting.HOT_CONFIG)  # hot路径

    #搜索首页-热门搜索模块（点击搜索框即调接口）
    def keywords(self,current_city_id,search_tab):
        self.params["current_city_id"] = current_city_id
        self.params["search_tab"] = search_tab
        return self.api_send(self.data["keywords"])

    #搜索结果页-医生/医院tab
    def content_v6(self, query, device_id, current_city_id, version, is_first, tab_type, offset, size):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #是否为第一次请求
        self.params['is_first'] = is_first
        #类型
        self.params['tab_type'] = tab_type
        #请求的页数 0，10，20
        self.params['offset'] = offset
        # 请求的size
        self.params['size'] = size
        return self.api_send(self.data["content_v6"])

    # 搜索首页-更美热门榜模块（点击搜索框即调接口）
    def hot(self, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params["version"] = version
        return self.api_send(self.data["hot"])


    # 品类聚合页面医生tab列表
    def hospital(self, cp_id, tag_id, q, count, device_id):
        self.params["cp_id"] = cp_id
        self.params["tag_id"] = tag_id
        self.params["q"] = q
        self.params["count"] = count
        self.params["device_id"] = device_id

        return self.api_send(self.data["hospital"])
if __name__ == '__main__':

    # 打印购物车-猜你喜欢列表接口返回
    print(search_request().hospital(82, [], "眼部整形", 10,  "869378034450718"))
