import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.diary_request import diary_request


class TestTopicData:
    data = BaseRequest().api_load(path_setting.DIARY_DATA)
    diary_data_case, diary_data_data = get_ids(data, "diary_data")

    @pytest.mark.parametrize("param",diary_data_data,ids=diary_data_case)
    def test_topic_data(self,param):
        # print(2)
        r = diary_request().diary_data(param["current_city_id"], param["diary_referrer"], param["sort"], param["count"], param["start_num"])
        # print(r)
        if r["error"] == 0:
            assert r["error"] == param["assert"]
            # 先判断有没有日记，然后判断日记本里面需要的那些字段，如点赞字段，日记总数等，不传值，传空值
            if r["data"][0]:
                assert r["data"][0]["post_date"] is not None and r["data"][0]["post_date"] is not "" #c创建时间
                assert r["data"][0]["diary_num"] is not None and r["data"][0]["diary_num"] is not "" #日记总数
                assert r["data"][0]["view_count"] is not None and r["data"][0]["view_count"] is not "" #浏览次数
                assert r["data"][0]["is_liked"] is not None and r["data"][0]["is_liked"] is not "" #是否点赞
                assert r["data"][0]["operation_day"] is not None and r["data"][0]["operation_day"] is not "" #术后多少天
                assert r["data"][0]["vote_count"] is not None and r["data"][0]["vote_count"] is not "" #点赞总数
                assert r["data"][0]["reply_count"] is not None and r["data"][0]["reply_count"] is not ""#评论总数
                assert r["data"][0]["id"] is not None and r["data"][0]["id"] is not ""#日记贴id


            # 判断评论列表里面的用户信息是否为空，如果有评论的话
            if r["data"][0]["comments"][0]:
                assert r["data"][0]["comments"][0]["user_id"] is not None and r["data"][0]["comments"][0]["user_id"] is not ""#用户id
                assert r["data"][0]["comments"][0]["nick_name"] is not None and r["data"][0]["comments"][0]["nick_name"] is not ""#用户名
                assert r["data"][0]["comments"][0]["gm_url"] is not None and r["data"][0]["comments"][0]["gm_url"] is not ""#点击头像跳转链接
            # assert(r[""])
        if r["error"] == 1:
            assert r["error"] == param["assert"]

