import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.gmai_request import gmai_request

# 测肤结果页
class TestSkinNewReport:
    data = BaseRequest().api_load(path_setting.GMAI_SKIN_NEWREPORT_DATA)
    skinnewReport_case, skinnewReport_data = get_ids(data, "skin_newReport")

    @pytest.mark.parametrize("param",skinnewReport_data,ids=skinnewReport_case)
    def test_skinnewReport(self,param):
        r = gmai_request().skin_newReport(param["version"], param["image_url"])
        if r["error"] == 0:
            data = r.get("data")

            # 大家都在买
            packages = data.get("packages")
            assert len(packages) == 6

            # 皮肤检测结果
            disadvantage_tabs = data.get("disadvantage_tabs")
            result_word = disadvantage_tabs[0].get("result_word")
            assert result_word == "色素型黑眼圈"



