import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestBeautyCardOrderConfirm:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_ORDER_CONFIRM)
    beauty_card_order_confirm_case, beauty_card_order_confirm_data = get_ids(data, "beauty_card_order_confirm")

    @pytest.mark.parametrize("param", beauty_card_order_confirm_data, ids=beauty_card_order_confirm_case)
    def test_beauty_card_order_confirm(self, param):
        r = janus_request().beauty_card_order_confirm(param["sku_id"], param["number"], param["use_bc_coupon"], param["bc_coupon_id"])

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]

