import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestProductCouponMyList:
    data = BaseRequest().api_load(path_setting.PRODUCT_COUPON_MY_LIST)
    product_coupon_my_list_case, product_coupon_my_list_data = get_ids(data, "product_coupon_my_list")

    @pytest.mark.parametrize("param", product_coupon_my_list_data, ids=product_coupon_my_list_case)
    def test_product_coupon_my_list(self, param):
        r = janus_request().product_coupon_my_list(param["start_num"], param["tab_id"])

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]

