import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestService:
    data = BaseRequest().api_load(path_setting.CONVERSATIONCOUPON)
    conversationcoupon_case, conversationcoupon_data = get_ids(data, "conversation_coupon")


    @pytest.mark.parametrize("param",conversationcoupon_data,ids=conversationcoupon_case)
    def test_conversation_coupon(self, param):
        '''发送美券按钮'''
        r = web_request().conversation_coupon(param["doctor_user_id"])
        if r["error"] == 0:
            data1 = r.get("data", [])
            assert len(data1) >= param["assert"]
