import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestConversationUserID:
    data = BaseRequest().api_load(path_setting.CONVERSATIONUSERID)
    userid_case, userid_data = get_ids(data, "conversation_user_id")


    @pytest.mark.parametrize("param",userid_data,ids=userid_case)
    def test_conversation_user_id(self, param):
        '''发送私信'''
        r = web_request().conversation_user_id(param["type"], param["content"], param["doctor_user_id"], param["t"], param["csrfmiddlewaretoken"])
        print(r)
        if r["error"] == 0:
            assert r["data"]["name"] == param["assert_name"]
            assert r["message"] == param["assert_message"]

        if r["error"] == 300009:
            assert r["message"] == param["assert_message1"]

       # if r["error"] == 300005:
         #   assert r["message"] == param["assert_message2"]#assert_message2: "该方法未经授权，无法访问"





