import path_setting
from in_common.base_request import BaseRequest


class skin_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.SKIN_RECOMMEND_SERVICE_CONFIG)

    # 测肤质底部feed流
    def skin_recommend_service(self, device_id, current_city_id, appeal_tag_ids, offset, size):
        self.params["current_city_id"] = current_city_id
        self.params["appeal_tag_ids"] = appeal_tag_ids
        self.params["offset"] = offset
        self.params["size"] = size
        self.params["device_id"] = device_id
        return self.api_send(self.data["skin_recommend_service"])


if __name__ == '__main__':
    print(skin_request().skin_recommend_service("androidid_7255c3398845cdd5", "beijing", '[2306,2303,2551,2355,2322,2337]', 0, 10))
