import path_setting
import requests
import yaml
"""
此文件是封装session的
"""

class LoginFunction:

    def __init__(self):
        self.host = self.login_yaml_load(path_setting.HOSTYAML_CONFIG)
        self.params = self.login_yaml_load(path_setting.LOGIN_FUNCTION_DATA)

    def login_yaml_load(self, path) -> list:
        with open(path, encoding='utf-8') as f:
            return yaml.safe_load(f)

    def get_session(self, host_service):
        project_login = host_service + "_login"
        url = self.host["develop_host"][host_service] + self.params[project_login]["url"]
        s = requests.session()
        r = s.request(
            self.params[project_login]["method"],
            url=url,
            params=self.params[project_login]["params"],
            data=self.params[project_login]["data"],
            headers={'Connection': 'close'},
            # verify=False
        )
        return s


if __name__ == '__main__':
    LoginFunction().get_session()