import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.answer_request import answer_request

class TestCancelVote:
    data = BaseRequest().api_load(path_setting.CANCEL_VOTE)
    cancelvote_case, cancelvote_data = get_ids(data, "cancel_vote")

    @pytest.mark.parametrize("param", cancelvote_data, ids=cancelvote_case)
    def test_cancel_vote(self, param):
        r = answer_request().cancel_vote(param["answer_id"])
        if r["error"] == 1:
            assert r["message"] == param["assert"]
