import pytest

from all_backend_api.doctor_request import doctor_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestArticle:
    data = BaseRequest().api_load(path_setting.DOCTOR_ARTICLE)
    article_case, article_data = get_ids(data, "article")

    @pytest.mark.parametrize("param", article_data, ids=article_case)
    def test_article(self, param):
        r = doctor_request().article(param["doctor_id"])

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]
