import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.face_request import face_request


class TestDiaryCards:
    data = BaseRequest().api_load(path_setting.FACE_DIARY_CARDS_DATA)
    FaceDiaryCards_case, FaceDiaryCards_data = get_ids(data, "diary_cards")

    @pytest.mark.parametrize("param",FaceDiaryCards_data,ids=FaceDiaryCards_case)
    def test_diary_cards(self,param):
        r = face_request().diarys_cards(param["facial_type2tag_names"])
        if r["error"] == 0:
            feed = r["data"]
            assert len(feed) == param["assert_feed_nums"]

            for key in feed:
                diary_cards = feed[key]
                assert diary_cards["__source"] == "diary"
                assert diary_cards["title"] is not None
                assert diary_cards["desc"] is not None
                assert diary_cards["diary"] is not None



