import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestUserStatus:
    data = BaseRequest().api_load(path_setting.USER_STATUS)
    user_status_case, user_status_data = get_ids(data, "user_status")

    @pytest.mark.parametrize("param", user_status_data, ids=user_status_case)
    def test_user_status_case(self, param):
        r = feed_request().user_status(param["current_city_id"], param["id"])
        if r["error"] == 0:
            assert r["data"]["is_regist"] == param["assert"]




