import pytest

from all_backend_api.hybrid_get_gift_request import hybrid_get_gift_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestGiftListData:
    data = BaseRequest().api_load(path_setting.GET_GIFT_DATA)
    get_gift_data_case, get_gift_data_data = get_ids(data, "get_gift_data")

    @pytest.mark.parametrize("param", get_gift_data_data, ids=get_gift_data_case)
    def test_get_gift_data(self, param):
        r = hybrid_get_gift_request().get_gift_data(param["gift_id"])

        if r["error"] == 1:
            assert r["message"] == param["assert_message"]


