import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestBeautyCardPaymentMethod:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_PAYMENT_METHOD)
    beauty_card_payment_method_case, beauty_card_payment_method_data = get_ids(data, "beauty_card_payment_method")

    @pytest.mark.parametrize("param", beauty_card_payment_method_data, ids=beauty_card_payment_method_case)
    def test_beauty_card_payment_method(self, param):
        payment = janus_request().beauty_card_order_submit("12345678912", "10176", 1, 1, 0, 0)
        payment_id = payment["data"]["payment_id"]
        r = janus_request().beauty_card_payment_method(payment_id)

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]

