import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.janus_request import janus_request


class TestServiceHospital:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_SERVICE_HOSPITAL)
    beauty_card_service_hospital_case, beauty_card_service_hospital_data = get_ids(data, "beauty_card_service_hospital")

    @pytest.mark.parametrize("param", beauty_card_service_hospital_data, ids=beauty_card_service_hospital_case)
    def test_beauty_card_service_hospital(self, param):
        r = janus_request().beauty_card_service_hospital(param["sku_id"], param["size"],
                                                         param["offset"], param["sort_type"])

        if param["sort_type"] == 1: #智能排序
            assert len(r["data"]["service_hospital_list"]) > 0
        if param["sort_type"] == 2: #离我最近
            assert len(r["data"]["service_hospital_list"]) > 0
        if param["sort_type"] == 3: #好评优先
            assert len(r["data"]["service_hospital_list"]) > 0
