import pytest

import path_setting
from all_backend_api.janus_request import janus_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#搜索结果页-综合/百科tab
class TestContentV7:
    data = BaseRequest().api_load(path_setting.CONTENTV7)
    contentv7_case, contentv7_data = get_ids(data, "content_v7")

    @pytest.mark.parametrize("param", contentv7_data, ids=contentv7_case)
    def test_content_v7(self, param):
        print(param['query'])
        r = janus_request().content_v7(param["query"], param["device_id"], param["current_city_id"], param["version"], param["is_first"], param["tab_type"], param["offset"])
        if r["error"] == 0:
            assert r["data"]["cards"][0]["type"] == param["assert"]
        if r["error"] == 1:
            assert r["message"] == param["assert"]