import pytest

import path_setting
from all_backend_api.janus_request import janus_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#医生医院sug列表
class TestKeywordTip:
    data = BaseRequest().api_load(path_setting.KEYWORDTIP)
    keywordtip_case, keywordtip_data = get_ids(data, "keyword_tip")

    @pytest.mark.parametrize("param", keywordtip_data, ids=keywordtip_case)
    def test_keyword_tip(self, param):
        print(param['query'])
        r = janus_request().keyword_tip(param["query"], param["lat"], param["lng"], param["version"])
        if not r["data"]["aggregation_card"]:
            print('医生医院卡片信息')
            assert r["data"]["tip_keys"][0]["type_flag"] == param["assert1"]
            assert r["data"]["tip_keys"][11]["type_flag"] == param["assert2"]
        if r["data"]["aggregation_card"] :
            print('百科卡片信息')
            assert r["data"]["aggregation_card"]["child"][0]["type_flag"] == param["assert1"]
            assert r["data"]["tip_keys"][0]["type_flag"] == param["assert2"]