import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.janus_request import janus_request


class TestTagService:
    data = BaseRequest().api_load(path_setting.TAG_SERVICE)
    tagservice_case, tagservice_data = get_ids(data, "tag_service")

    @pytest.mark.parametrize("param", tagservice_data, ids=tagservice_case)
    def test_tag_service(self, param):
        r = janus_request().tag_service(param["size"], param["tag_ids"], param["offset"], param["tag_id"], param["version"], param["device_id"])
        #print('feng=', r)

        if r["error"] == 0:
         assert r["error"] == param["assert"]
         assert r["data"]["offset"] == param["offset"]
