import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.oneimage_request import oneimage_request


class TestShareV4:
    """
    测颜值结果页，分享结果
    """
    data = BaseRequest().api_load(path_setting.ONEIMAGE_SHARE_V4_DATA)
    sharev4_case, sharev4_data = get_ids(data, "share_v4")

    # @pytest.mark.skip("跳过，测颜值结果v4，目前数据是线上的-------------------")
    @pytest.mark.parametrize("param",sharev4_data,ids=sharev4_case)
    def test_share_v4(self,param):
        r = oneimage_request().share_v4(param["version"], param["face_id"])
        assert r["error"] == 0
        face_name = r["data"]["face_desc"]["face_name"]
        assert face_name is not None

        classification_info = r["data"]["classification_info"]
        # 测颜值结果,保证五官有值
        for key,value in classification_info.items():
            # print(key, value["name"], value["param"])
            assert value["name"] is not None
            assert value["param"] is not None
        # 颜值报告
        content = r["data"]["tractate_info"]["content"]
        # print(content)
        assert content is not None
        # 五官描述
        info_list = r["data"]["facial_feature"]["info_list"]
        for item in info_list:
            print(item["family"], item["description"])
            assert item["family"] is not None
            assert item["description"] is not None

        # 底部按钮
        bottom_buttons = r["data"]["bottom_buttons"]
        assert bottom_buttons[0]["gm_url"] == param["skin_url"]
        assert bottom_buttons[0]["name"] == param["skin_name"]
        assert bottom_buttons[1]["gm_url"] == param["con_url"]
        assert bottom_buttons[1]["name"] == param["con_name"]