import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.service_request import service_request


class TestProductMallServiceHomeFeed:
    data = BaseRequest().api_load(path_setting.FEED_TAB_SERVICE_DOCTORS)
    productmallservicehomefeed_case, productmallservicehomefeed_data = get_ids(data, "home_feed")

    @pytest.mark.parametrize("param", productmallservicehomefeed_data, ids=productmallservicehomefeed_case)
    def test_product_mall_service_home_feed(self,param):
        r = service_request().feed_home(param["tab_value"], param["input_type"])
        assert r["error"] == 0
        if r["error"] == 0:
            s = param["tab_value"] + "s"
            features = r["data"][s]
            assert len(features) > param["assert"]


