import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.topic_request import topic_request



class TestVote:
    data = BaseRequest().api_load(path_setting.TOPIC_VOTE)
    topic_vote_case, topic_vote_data = get_ids(data, "topic_vote")

    @pytest.mark.parametrize("param", topic_vote_data, ids=topic_vote_case)
    def test_vote(self, param):
        r = topic_request().topic_detail(param["topic_id"])
        if r["error"] == 0:
            assert r["error"] == param["assert1"]
            # 如果没有点过赞，就先校验点赞之后再取消点赞。【最后保持取消点赞的状态】
            if not r["data"]["data"]["is_liked"]:
                vote = topic_request().topic_vote(param["topic_id"])
                assert vote["error"] == 0
                assert vote["message"] == param["message1"]
                # 取消点赞，回到取消点赞的状态
                cancelvote = topic_request().topic_cancelvote(param["topic_id"])
                assert cancelvote["error"] == 0
            else:
                # 如果是已经点过赞的状态就直接取消点赞
                cancelvote = topic_request().topic_cancelvote(param["topic_id"])
                assert cancelvote["error"] == 0
                assert cancelvote["message"] == param["message2"]






# if r["error"] == 1:
#     assert r["message"] ==param["assert2"]


#     收藏之后取消收藏
# r1 = diary_isfavor_request().diary_cancelfavor()
# if r["error"] == 0:
#     assert r["error"] == param["assert"]






