import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request

class TestReply:
    data = BaseRequest().api_load(path_setting.TRACTATE_REPLY)
    reply_case, reply_data = get_ids(data, "reply")

    @pytest.mark.parametrize("param", reply_data, ids=reply_case)
    def test_reply(self, param):
        r = tractate_request().reply( param["current_city_id"], param["id"], param["data_type"] )
        # print(r)
        assert r["error"] == param["assert_error"]
        if r["error"] == 0:
            # 先判断有没有值，然后判断里面需要的那些字段，如点赞字段，总数等，不传值，传空值
            if r["data"]["reply"]:
                assert r["data"]["reply"][0]["content"] is not None and r["data"]["reply"][0]["content"] is not ""
                assert r["data"]["reply"][0]["user_id"] is not None and r["data"]["reply"][0]["user_id"] is not ""
                assert r["data"]["reply"][0]["user_gm_url"] is not None and r["data"]["reply"][0]["user_gm_url"] is not ""
                assert r["data"]["reply"][0]["user_portrait"] is not None and r["data"]["reply"][0]["user_portrait"] is not ""
                assert r["data"]["reply"][0]["vote_num"] is not None and r["data"]["reply"][0]["vote_num"] is not ""
                assert r["data"]["reply"][0]["user_type"] is not None and r["data"]["reply"][0]["user_type"] is not ""
                assert r["data"]["reply"][0]["user_name"] is not None and r["data"]["reply"][0]["user_name"] is not ""
                assert r["data"]["reply"][0]["tractate_id"] is not None and r["data"]["reply"][0]["tractate_id"] is not ""
                assert r["data"]["reply"][0]["reply_count"] is not None and r["data"]["reply"][0]["reply_count"] is not ""
                assert r["data"]["reply"][0]["is_vote"] is not None and r["data"]["reply"][0]["is_vote"] is not ""
                assert r["data"]["reply"][0]["id"] is not None and r["data"]["reply"][0]["id"] is not ""
            else:
                # print(r["data"]["reply"])
                # 如果得到结果是无评论看是不是写死的无评论的账号还是别的原因导致
                assert r["data"]["tractate_id"] == str(param["id"])

