import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestFavorsServices:
    data = BaseRequest().api_load(path_setting.FAVORS_SERVICES)
    favors_services_case, favors_services_data = get_ids(data, "favors_services")

    @pytest.mark.parametrize("param", favors_services_data, ids=favors_services_case)
    def test_favors_services(self, param):
        r = user_request().favors_services(param["start_num"], param["count"], param["current_city_id"], param["device_id"], param["version"])

        assert r["error"] == param["assert"]

