import pytest
from bs4 import BeautifulSoup

import path_setting
from all_backend_api.wiki_request import wiki_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#百科详情页-项目百科，水光针
class TestWikiItem:
    data = BaseRequest().api_load(path_setting.WIKI_ITEM)
    wiki_item_case, wiki_item_data = get_ids(data, "wiki_item")

    @pytest.mark.parametrize("param", wiki_item_data, ids=wiki_item_case)
    def test_wiki_item(self, param):
        r = wiki_request().wiki_item(param["tag_ids"], param["q"], param["start_num"], param["version"], param["device_id"])
        # soup = BeautifulSoup(r, 'lxml')  # html.parser是解析器，也可是lxml
        if r["data"] is True:
            assert r["data"]["item_id"] == param["assert"]
        print('进入项目百科-水光针的百科详情页')