import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestConversationUnreadList:
    data = BaseRequest().api_load(path_setting.CONVERSATIONUNREADLIST)
    unreadlist_case, unreadlist_data = get_ids(data, "conversation_unread_list")


    @pytest.mark.parametrize("param",unreadlist_data,ids=unreadlist_case)
    def test_conversation_unread_list(self, param):
        '''未读私信列表'''
        r = web_request().conversation_unread_list(param["page"])
        if r["error"] == 0:
            conversation = r.get("data").get("conversation", [])
            assert len(conversation) <= param["assert"]
            assert r["data"]["size"] <= param["assert_size"]

