import path_setting
from in_common.base_request import BaseRequest

class settlement_request(BaseRequest):
    def __init__(self):
        self.preview = self.api_load(path_setting.PREVIEW_V1)

    def preview_v1(self, current_city_id, service_item_id, number, use_platform_coupon, use_doctor_coupon, use_coupon_grey, is_create_groupbuy):
        self.params["current_city_id"] = current_city_id
        self.params["service_item_id"] = service_item_id
        self.params["number"] = number
        self.params["use_platform_coupon"] = use_platform_coupon
        self.params["use_doctor_coupon"] =use_doctor_coupon
        self.params["use_coupon_grey"] = use_coupon_grey
        self.params["is_create_groupbuy"] = is_create_groupbuy
        return self.api_send(self.preview["preview_v1"])

    def pay_v1(self, actual_pay, payment_final_price, is_contains_groupbuy_order,mul_orders_number):
        self.params["actual_pay"] = actual_pay
        self.params["payment_final_price"] = payment_final_price
        self.params["is_contains_groupbuy_order"] = is_contains_groupbuy_order
        self.params["mul_orders_number"] = mul_orders_number
        return self.api_send(self.preview["pay_v1"])

    def create_v1(self,service_item_id, number,platform_coupon_id,use_point,is_doctor_see,doctor_coupon_id,insurance_info,is_create_groupbuy):
        self.params["service_item_id"] = service_item_id
        self.params["number"] = number
        self.params["platform_coupon_id"] = platform_coupon_id
        self.params["use_point"] = use_point
        self.params["is_doctor_see"] = is_doctor_see
        self.params["doctor_coupon_id"] = doctor_coupon_id
        self.params["insurance_info"] = insurance_info
        self.params["is_create_groupbuy"] = is_create_groupbuy
        return self.api_send(self.preview["create_v1"])

    def pay(self,id):
        self.params["id"] = id
        return self.api_send(self.preview["pay"])

    def detail(self, id):
        self.params["id"] = id
        return self.api_send(self.preview["detail"])

    def delete(self, id, cancel_reason_value):
        self.params["id"] = id
        self.params["cancel_reason_value"] = cancel_reason_value
        return self.api_send(self.preview["delete"])



if __name__ == '__main__':
    # print(settlement_request().preview_v1("beijing", "599428", 1, 1, 1, "true", 0))
    print(settlement_request().delete("522139664651","不想买了"))