import path_setting
from in_common.base_request import BaseRequest


class user_request(BaseRequest):

    def __init__(self):
        self.data = self.api_load(path_setting.PERSONAL_CENTER_CONFIG)

    def personal_center(self):

        return self.api_send(self.data["personal_center"])


    def __init__(self):
        self.data = self.api_load(path_setting.USER_ANSWER_CONFIG)

    #医院主页问答列表
    def answer(self, user):
        self.params["user"] = user
        return self.api_send(self.data["answer"])
    #日记贴相关部分配置
    def __init__(self):
        self.data = self.api_load(path_setting.TOPIC_FAVOR_CONFIG)

    #日记贴帖子相关-收藏
    def topic_favor(self):
        return self.api_send(self.data["favor"])
    #日记贴取消收藏
    def topic_canclefavor(self):
        return self.api_send(self.data["canclefavor"])

    #关注主播
    def follow_add(self,uid,from_live):
        self.params["uid"] = uid
        self.params["from_live"] = from_live
        return self.api_send(self.data['follow_add'])

    #取消关注
    def follow_del(self,uid,from_live):
        self.params["uid"] = uid
        self.params["from_live"] = from_live
        return self.api_send(self.data["follow_del"])




    #我的-日记
    def my_diary_v2(self, start_num, count):

        self.params["start_num"] = start_num
        self.params["count"] = count



        return self.api_send(self.data["my_diary_v2"])

     # 我的-帖子-我发布的
    def user_tractate(self, page, count):

        self.params["page"] = page
        self.params["count"] = count


        return self.api_send(self.data["user_tractate"])

     # 我的-帖子-我回复的
    def reply_tractate(self, page, count, version):

        self.params["page"] = page
        self.params["count"] = count
        self.params["version"] = version


        return self.api_send(self.data["reply_tractate"])


     # 我的-问题-提问
    def my_question(self, start_num, count):

        self.params["start_num"] = start_num
        self.params["count"] = count


        return self.api_send(self.data["my_question"])

     # 我的-收藏-商品
    def favors_services(self, start_num, count, current_city_id, device_id, version):

        self.params["start_num"] = start_num
        self.params["count"] = count
        self.params["current_city_id"] = current_city_id
        self.params["device_id"] = device_id
        self.params["version"] = version

        return self.api_send(self.data["favors_services"])

     # 我的-问题-回答
    def my_answer(self, start_num, count):

        self.params["start_num"] = start_num
        self.params["count"] = count

        return self.api_send(self.data["my_answer"])

     # 我的-收藏-日记本
    def favors_diaries(self, start_num, count):

        self.params["start_num"] = start_num
        self.params["count"] = count

        return self.api_send(self.data["favors_diaries"])

     # 我的-收藏-日记贴
    def favors_topics(self, start_num, count):

        self.params["start_num"] = start_num
        self.params["count"] = count

        return self.api_send(self.data["favors_topics"])

     # 我的-收藏-帖子
    def favors_tractate(self, page, count):

        self.params["page"] = page
        self.params["count"] = count

        return self.api_send(self.data["favors_tractate"])

     # 我的-收藏-回答
    def favors_answers(self, page, count):

        self.params["page"] = page
        self.params["count"] = count

        return self.api_send(self.data["favors_answers"])



if __name__ == '__main__':
    #个人中心
    print(user_request().personal_center())


    #打印医生/医院主页问答列表接口返回
    print(user_request().answer("21476198"))

    # 日记贴收藏&取消收藏
    # print(user_request().topic_favor())
    # print(user_request().topic_canclefavor())
    print(user_request().follow_del("33909625","4196"))

    #我的-日记
    print(user_request().my_diary_v2(0, 10))

    #我的-帖子-我发布的
    print(user_request().user_tractate(1, 10))

    #我的-问题
    print(user_request().my_question(0, 10))

    #我的-问题
    print(user_request().favors_services(0, 10, "beijing", "androidid_16a95f3fa31a4c0b", "7.46.0"))
    #我的-帖子-我回复的
    print(user_request().reply_tractate(1, 10, "7.46.0"))

    # 我的-问题-回答
    print(user_request().my_answer(0, 10))

    # 我的-收藏-日记本
    print(user_request().favors_diaries(0, 10))

    # 我的-收藏-日记贴
    print(user_request().favors_topics(0, 10))

   # 我的-收藏-帖子
    print(user_request().favors_tractate(1, 10))

   # 我的-收藏-帖子
    print(user_request().favors_answers(1, 10))




