import path_setting
from in_common.base_request import BaseRequest


class beautycard_request(BaseRequest):
    def __init__(self):
        #更美次卡-获取已添加页面次卡spu/sku列表
        self.data = self.api_load(path_setting.GET_RELATED_BC_CONFIG)
        #更美次卡-删除/批量删除已添加页面次卡
        self.data = self.api_load(path_setting.DELETE_RELATED_BC_CONFIG)
        #更美次卡-已添加页面全部导出
        self.data = self.api_load(path_setting.EXPORT_RELATED_BC_CONFIG)
        #更美次卡-更改次卡排序
        self.data = self.api_load(path_setting.UPDATE_BC_RANK_CONFIG)
        #更美次卡-按次卡sku_id导入，导入校验
        self.data = self.api_load(path_setting.CHECK_SKU_IDS_CONFIG)

    #更美次卡-获取已添加页面次卡spu/sku列表
    def get_related_bc(self, unit_id, bc_sku_id, bc_spu_id, page, page_size):
        self.params["unit_id"] = unit_id
        self.params["bc_sku_id"] = bc_sku_id
        self.params["bc_spu_id"] = bc_spu_id
        self.params["page"] = page
        self.params["page_size"] = page_size

        return self.api_send(self.data["get_related_bc"])

    #更美次卡-删除/批量删除已添加页面次卡
    def delete_related_bc(self, unit_id, bc_sku_ids, bc_spu_ids, related_type):
        self.params["unit_id"] = unit_id
        self.params["bc_sku_ids"] = bc_sku_ids
        self.params["bc_spu_ids"] = bc_spu_ids
        self.params["related_type"] = related_type

        return self.api_send(self.data["delete_related_bc"])

    #更美次卡-已添加页面全部导出
    def export_related_bc(self, unit_id, bc_sku_id, bc_spu_id):
        self.params["unit_id"] = unit_id
        self.params["bc_sku_id"] = bc_sku_id
        self.params["bc_spu_id"] = bc_spu_id

        return self.api_send(self.data["export_related_bc"])

    #更美次卡-更改次卡排序
    def update_bc_rank(self, unit_id, related_id, related_type, rank):
        self.params["unit_id"] = unit_id
        self.params["related_id"] = related_id
        self.params["related_type"] = related_type
        self.params["rank"] = rank

        return self.api_send(self.data["update_bc_rank"])

    #更美次卡-按次卡sku_id导入，导入校验
    def check_sku_ids(self, bc_skus):
        self.params["bc_skus"] = bc_skus

        return self.api_send(self.data["check_sku_ids"])

    #更美次卡-按次卡spu_id导入，导入校验
    def check_spu_ids(self, bc_spus):
        self.params["bc_spus"] = bc_spus

        return self.api_send(self.data["check_spu_ids"])

if __name__ == '__main__':
    print(beautycard_request().get_related_bc("20105", "", "", "0", "10"))
    print(beautycard_request().delete_related_bc("19931", "[10163]", "[]", "8"))
    print(beautycard_request().export_related_bc("19933", "", ""))
    print(beautycard_request().update_bc_rank("20105", "100023", "7", "11"))