import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.account_request import account_request


class TestAccount_Homepage:
    data = BaseRequest().api_load(path_setting.ACCOUNT_HOMEPAGE)
    account_homepage_case, account_homepage_data = get_ids(data, "account_homepage")

    @pytest.mark.parametrize("param", account_homepage_data, ids=account_homepage_case)
    def test_account_homepage(self, param):
        r = account_request().account_homepage(param["user_id"], param["device_id"])

        assert r["error"] == param["assert"]

