import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.auto_complete_request import auto_complete_request


class TestDoctor:
    data = BaseRequest().api_load(path_setting.AUTO_COMPLE_HOSPITAL)
    hospital_case, hospital_data = get_ids(data, "hospital")

    @pytest.mark.parametrize("param",hospital_data,ids=hospital_case)
    def test_doctor(self,param):
        r = auto_complete_request().hospital(param["q"])
        if r["error"] == 0:
            data = r["data"]
            assert len(data) > param["assert"]


