import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.common_request import common_request


class TestReply:
    data = BaseRequest().api_load(path_setting.DIARY_COMMON_REPLY)
    diary_common_reply_case, diary_common_reply_data = get_ids(data, "common_reply")

    @pytest.mark.parametrize("param", diary_common_reply_data, ids=diary_common_reply_case)
    def test_reply(self, param):
        # 日记贴的评论列表
        r = common_request().diary_common_reply(param["id"], param["com_type"])
        # print(r)
        if r["error"] == 0:
            assert r["error"] == param["assert1"]
            # 先判断有没有评论，然后判断里面需要的那些字段，如点赞字段，评论总数等，不传值，传空值
            if r["data"]["reply_data"] and (param["assert1"] == 2):
                assert r["data"]["reply_data"][0]["user_id"] is not None and r["data"]["reply_data"][0]["user_id"] is not ""  # 用户id
                assert r["data"]["reply_data"][0]["user_portrait"] is not None and r["data"]["reply_data"][0]["user_portrait"] is not ""  # 用户头像
                assert r["data"]["reply_data"][0]["gm_url"] is not None and r["data"]["reply_data"][0]["gm_url"] is not ""  # 头像跳转链接
                assert r["data"]["reply_data"][0]["user_nickname"] is not None and r["data"]["reply_data"][0]["user_nickname"] is not ""  # 用户名
                assert r["data"]["reply_data"][0]["content"] is not None and r["data"]["reply_data"][0]["content"] is not ""  # 评论内容
                assert r["data"]["reply_data"][0]["reply_count"] is not None and r["data"]["reply_data"][0]["reply_count"] is not ""  # 评论总数
                assert r["data"]["reply_data"][0]["reply_id"] is not None and r["data"]["reply_data"][0]["reply_id"] is not ""  # 评论id
                assert r["data"]["reply_data"][0]["is_voted"] is not None and r["data"]["reply_data"][0]["is_voted"] is not ""  # 是否点赞
                assert r["data"]["reply_data"][0]["_type"] == param["type"]  # 校验评论列表返回类型







