import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.diary_request import diary_request


class TestDiaryService:
    data = BaseRequest().api_load(path_setting.DIARY_SERVICE)
    diary_service_case, diary_service_data = get_ids(data, "diary_service")

    @pytest.mark.parametrize("param", diary_service_data,ids=diary_service_case)
    def test_diary_service(self, param):
        # print(2)
        r = diary_request().diary_service( param["diary_id"], param["service_id"])
        # print(r)
        if r["error"] == 0:
            assert r["error"] == param["assert"]
            # 先判断有没有美购的字段，没有就检验接口就行，然后判断接口里面需要的那些字段是否不传值，传空值

            if r["data"]["service_data"]:
                assert r["data"]["service_data"]["gengmei_price"] is not None and r["data"]["service_data"]["gengmei_price"] is not ""  # 更美价
                assert r["data"]["service_data"]["service_name"] is not None and r["data"]["service_data"]["service_name"] is not ""  # 美购名称
                assert r["data"]["service_data"]["gm_url"] is not None and r["data"]["service_data"]["gm_url"] is not ""  # 跳转链接
                assert r["data"]["service_data"]["is_seckill"] is not None and r["data"]["service_data"]["is_seckill"] is not ""  # 是否秒杀






