import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.diary_request import diary_request



class TestVote:
    data = BaseRequest().api_load(path_setting.DIARY_VOTE)
    diary_vote_case, diary_vote_data = get_ids(data, "diary_vote")

    @pytest.mark.parametrize("param", diary_vote_data, ids=diary_vote_case)
    def test_vote(self, param):
        r = diary_request().diary_vote(param["diary_id"])
        # 如果点赞成功，就走取消点赞的流程，否则先取消点赞再去点赞
        if r["message"] == param["assert2"]:
            # 之后取消点赞。【最后保持取消点赞的状态】
            cancel_vote = diary_request().diary_cancel_vote(param["diary_id"])
            assert cancel_vote["error"] == 0
        else:
            # 如果是已经点过赞的状态就直接取消点赞,然后再走一遍点赞-取消点赞;一般不走这边除非手动点过这个卡片
            assert r["message"] == param["assert3"]
            cancel_vote = diary_request().diary_cancel_vote(param["diary_id"])
            assert cancel_vote["error"] == 0
            vote = diary_request().diary_vote(param["diary_id"])
            assert vote["message"] == param["assert2"]
            cancel_vote = diary_request().diary_cancel_vote(param["diary_id"])
            assert cancel_vote["error"] == 0







