import pytest

from all_backend_api.hybrid_promotion_request import hybrid_promotion_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestTelatedServiceData:
    data = BaseRequest().api_load(path_setting.RELATED_SERVICE_DATA)
    related_service_data_case, related_service_data_data = get_ids(data, "related_service_data")

    @pytest.mark.parametrize("param", related_service_data_data, ids=related_service_data_case)
    def test_related_service_data(self, param):
        r = hybrid_promotion_request().related_service_data(param["service_id"], param["page"])

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]

