import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.im_request import im_request


class TestAutoMsg:
    data = BaseRequest().api_load(path_setting.AUTO_MSG)
    automsg_case, automsg_data = get_ids(data, "auto_msg")

    @pytest.mark.parametrize("param",automsg_data,ids=automsg_case)
    def test_auto_msg(self,param):
        r = im_request().auto_msg(param["trace_id"], param["conversation_id"])
        if r["error"] == 0:
            assert r["data"]["send_result"] == param["assert"]

