import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestBeautyCardOrderConfirm:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_ORDER_CONFIRM)
    beauty_card_order_confirm_case, beauty_card_order_confirm_data = get_ids(data, "beauty_card_order_confirm")

    @pytest.mark.parametrize("param", beauty_card_order_confirm_data, ids=beauty_card_order_confirm_case)
    def test_beauty_card_order_confirm(self, param):
        r = janus_request().beauty_card_order_confirm(param["sku_id"], param["number"], param["use_bc_coupon"], param["bc_coupon_id"])

        if param["number"] == 1: #购买1个sku时
            assert r["error"] == param["assert_error"]
            assert r["data"]["payment_total_price"] == param["assert_total_price"]
            assert r["data"]["payment_total_fee"] == param["assert_total_fee"]
            assert r["data"]["user_buy_lower_limit"] == param["assert_user_buy_lower_limit"]
            assert r["data"]["user_buy_upper_limit"] == param["assert_user_buy_upper_limit"]
            assert r["data"]["is_doctor_see"] == param["assert_is_doctor_see"]
        if param["number"] == 2: #购买2个sku时
            assert r["error"] == param["assert_error"]
            assert r["data"]["payment_total_price"] == param["assert_total_price"]
            assert r["data"]["payment_total_fee"] == param["assert_total_fee"]
            assert r["data"]["user_buy_lower_limit"] == param["assert_user_buy_lower_limit"]
            assert r["data"]["user_buy_upper_limit"] == param["assert_user_buy_upper_limit"]


