import pytest

import path_setting
from all_backend_api.janus_live_request import live_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestPopService:
    data = BaseRequest().api_load(path_setting.POP_SERVICE)
    pop_service_case, pop_service_data = get_ids(data, "pop_service")

    @pytest.mark.parametrize("param", pop_service_data, ids=pop_service_case)

    def test_pop_service(self,param):
        r = live_request().pop_service(param["stream_id"], param["live_service_id"], param["pop_type"], param["version"])
        if r["error"] == 0:
            print("成功弹出商品卡片")
            assert r["data"]["live_service_id"] == param["assert"]
        else:
            print("出错了！！！")