import pytest
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.live_request import living_request


class TestGetLiveInfoAudience:
    data = BaseRequest().api_load(path_setting.GET_LIVE_INFO_AUDIENCE)
    get_live_info_audience_case, get_live_info_audience_data = get_ids(data,"get_live_info_audience")

    @pytest.mark.parametrize("param", get_live_info_audience_data, ids=get_live_info_audience_case)
    def test_get_live_info_audience(self, param):
        r = living_request().get_live_info_audience(param["channel_id"], param["version"])
        print("主播分享直播间")
        if r["error"] == 0:
            assert r["data"]["channel_id"] == param["assert"]
            assert r["data"]["share_data"]["wechat"]["title"][0:7] == param["assert0"]
            assert r["data"]["share_data"]["wechatline"]["title"][0:7] == param["assert0"]
            assert r["data"]["share_data"]["qq"]["title"][0:7] == param["assert0"]