import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.my_conversation_request import my_conversation_request


class TestMyConversation:
    data = BaseRequest().api_load(path_setting.MY_CONVERSATION)
    my_conversation_case, my_conversation_data = get_ids(data, "my_conversation")


    @pytest.mark.parametrize("param",my_conversation_data,ids=my_conversation_case)
    def test_my_conversation(self,param):
        '''私信列表'''
        r = my_conversation_request().my_conversation(param["current_city_id"], param["start_num"], param["count"])
        if r["error"] == 0:
            conversation_list = r.get("data").get("conversation_list", [])
            assert len(conversation_list) <= param["assert"]

