import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.orders_request import orders_request


class TestOrdersMyV2Used:
    data = BaseRequest().api_load(path_setting.ORDERS_MY_V2_DATA)
    my_order_used_case, my_order_used_data = get_ids(data, "used")

    @pytest.mark.parametrize("param",my_order_used_data,ids=my_order_used_case)
    def test_orders_used(self,param):
        no_more_data = False
        i = 0
        found_usedBeautycard = False
        while no_more_data is False:
            r = orders_request().my_v2(i*10, param["status"], param["version"])
            i += 1
            no_more_data = r["data"]["no_more_data"]
            for order in r["data"]["orders"]:
                if order["type"] == 4 and order["order"]["order_status"]["status"] == 5:
                    found_usedBeautycard = True
                    order_id = order["order"]["order_id"]
                    print("次卡单id：  ", order_id)
                    # 按钮文案
                    text = order["order"]["order_status"]["text"]
                    assert text == "已使用"
                    assert order["gm_url"] == "gengmei://order_beauty_card_detail?order_id={}&type=4".format(order_id)
                    # 按钮信息
                    buttons_title = order["buttons"][0]["title"]
                    buttons_url = order["buttons"][0]["url"]
                    assert buttons_title == "立即领取面膜"
                    assert buttons_url == "gengmei://common_webview?url=https://backend.igengmei.com/phantom/visual_special/2340"
                    # 7.46.0加的头图信息
                    icon_url = order["header"]["icon_url"]
                    gm_url = order["header"]["gm_url"]
                    title = order["header"]["title"]
                    break
            if found_usedBeautycard: break


