import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.private_conversation_request import private_conversation_request


class TestPrivateConversation:
    data = BaseRequest().api_load(path_setting.PRIVATE_CONVERSATION)
    privateconversation_case, privateconversation_data = get_ids(data, "private_conversation")

    @pytest.mark.parametrize("param", privateconversation_data, ids=privateconversation_case)
    def test_private_conversation(self, param):
        r = private_conversation_request().private_conversation(param["content"], param["target_uid"],
                                                                param["referrer"], param["referrer_id"],
                                                                param["is_system"], param["quick_consultation_id"],
                                                                param["diary_id"], param["from_live"])
        print(r)
        if r["error"] == 0:
            assert r["message"] == param["assert_message"]
            assert r["data"]["text"] == param["assert_text"]
        if r["error"] == 21001:
            assert r["message"] == param["assert_message1"]