import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.skin_request import skin_request

# 测肤底部feed流
class TestSkinRecommendServices:
    data = BaseRequest().api_load(path_setting.SKIN_RECOMMEND_SERVICE_DATA)
    skin_recommend_service_case, skin_recommend_service_data = get_ids(data, "recommend_service")

    @pytest.mark.parametrize("param",skin_recommend_service_data,ids=skin_recommend_service_case)
    def test_recommend_services(self,param):
        r = skin_request().skin_recommend_service(param["device_id"], param["current_city_id"], param["appeal_tag_ids"],
                                                  param["offset"], param["size"])
        if r["error"] == 0:
            services = r["data"]["services"]
            assert len(services) == param["assert_nums"]
