import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestFavorsAnswers:
    data = BaseRequest().api_load(path_setting.FAVORS_ANASWERS)
    favors_answers_case, favors_answers_data = get_ids(data, "favors_answers")

    @pytest.mark.parametrize("param", favors_answers_data, ids=favors_answers_case)
    def test_favors_answers(self, param):
        r = user_request().favors_answers(param["page"], param["count"])

        assert r["error"] == param["assert"]

