import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestFavorsTractate:
    data = BaseRequest().api_load(path_setting.FAVORS_TRACTATE)
    favors_tractate_case, favors_tractate_data = get_ids(data, "favors_tractate")

    @pytest.mark.parametrize("param", favors_tractate_data, ids=favors_tractate_case)
    def test_favors_tractate(self, param):
        r = user_request().favors_tractate(param["page"], param["count"])

        assert r["error"] == param["assert"]

