import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestUserTractate:
    data = BaseRequest().api_load(path_setting.USER_TRACTATE)
    user_tractate_case, user_tractate_data = get_ids(data, "user_tractate")

    @pytest.mark.parametrize("param", user_tractate_data, ids=user_tractate_case)
    def test_user_tractate(self, param):
        r = user_request().user_tractate(param["page"], param["count"])

        if r["error"] == 0:
         assert len(r["data"]["tractates"]) >= param["assert"]

