import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web2_request import web2_request


class TestArtemisCpcCategorypromotemanageList:
    data = BaseRequest().api_load(path_setting.CPCCATEGORYPROMOTEMANAGELIST)
    cpccategorypromotemanagelist_case, cpccategorypromotemanagelist_data = get_ids(data, "artemis_cpc_categorypromotemanage_list")


    @pytest.mark.parametrize("param",cpccategorypromotemanagelist_data,ids=cpccategorypromotemanagelist_case)
    def test_artemis_cpc_categorypromotemanage_list(self, param):
        '''点点通商品-品类推广管理'''
        r = web2_request().artemis_cpc_categorypromotemanage_list(param["promote_flag"], param["id"])
        print(r)
        if r["error"] == 0:
            assert r["data"]["is_cpc"] == param["assert_cpc"]
            manage_list = r.get("data").get("manage_list", [])
            assert len(manage_list) >= param["assert"]



