import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestCpcCommunityHomepage:
    data = BaseRequest().api_load(path_setting.CPCCOMMUNITYHOMEPAGE)
    cpccommunityhomepage_case, cpccommunityhomepage_data = get_ids(data, "cpc_community_homepage")


    @pytest.mark.parametrize("param",cpccommunityhomepage_data,ids=cpccommunityhomepage_case)
    def test_cpc_community_homepage(self, param):
        '''点点通-概览'''
        r = web_request().cpc_community_homepage()
        if r["error"] == 0:
            if r["data"]["account"] <= "0":
                assert r["data"]["is_cpc"] == param["assert"]
            else:
                assert r["data"]["is_cpc"] == param["assert1"]

