import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.oneimage_request import oneimage_request

# 测颜值根据五官推荐美购
class TestRecomendServices:
    data = BaseRequest().api_load(path_setting.ONEIMAGE_RECOMEND_SERVICES_DATA)
    recomendservice_case, recomendservice_data = get_ids(data, "recomend_services")

    @pytest.mark.skip("跳过测颜值根据五官推荐美购，目前数据是参数是线上的-------------------")
    @pytest.mark.parametrize("param",recomendservice_data,ids=recomendservice_case)
    def test_recomend_services(self,param):
        r = oneimage_request().recomend_services(param["version"], param["business_tags_names"])
        if r["error"] == 0:
            data = r.get("data")
            assert len(data) == param["assert"]
            gm_url = data[0].get("gm_url")
            assert gm_url.startswith("gengmei://search_result?searchTabType=0") == True, f'返回并非搜索协议,实际是{gm_url}'
            assert len(data[0].get("service")) > 0, f'根据五官返回美购个数有误，实际是{len(data[0].get("service"))}'


